float4 main(float2 texCoord: TEXCOORD0, uniform sampler2D Image : register(S0), uniform sampler2D offsetTex : register(S1)) : COLOR
{
   float pixelSizeX = 1.0f / 800.0f;
   float pixelSizeY = 1.0f / 600.0f;
   
   float4 offset = tex2D(offsetTex, texCoord);
   float4 output = offset;
        
   float4 pixValue = 0;
   
   offset.x -= 0.5;
   offset.y -= 0.5;

   offset.x *= 0.195;
   offset.y *= 0.195;
   
   offset.x = frac(texCoord.x + offset.x);
   offset.y = frac(texCoord.y + offset.y);
   pixValue = tex2D(Image, offset);

   output = pixValue;
 
   return output;
}

