#define IN_HLSL
#include "shdrConsts.h"

//---------------------------------------------------------------
// Constants
//---------------------------------------------------------------
struct Appdata
{
    float4 position        : POSITION;
    float4 texCoord        : TEXCOORD0;

};
struct Conn
{
   float4 HPOS             : POSITION;
   float2 outTexCoord     : TEXCOORD0;

};
//---------------------------------------------------------------
// Main
//---------------------------------------------------------------
Conn main( Appdata In, uniform float4x4 modelview : register(VC_WORLD_PROJ),
              uniform float4x4 texMat          : register(VC_TEX_TRANS1)

 )
{
   Conn Out;

   //take vert and get coord by transforming by modelviewmatrix
   Out.HPOS = mul(modelview, In.position);
   //set base texture coord
   Out.outTexCoord = In.texCoord; //mul(texMat, In.texCoord);
   return Out;
}