//*****************************************************************************
//*****************************************************************************
//-----------------------------------------------------------------------------
// Structures                                                                  
//-----------------------------------------------------------------------------
struct VertData
{
   float2 texCoord        : TEXCOORD0;
   float2 lmCoord         : TEXCOORD1;
   float3 T               : TEXCOORD2;
   float3 B               : TEXCOORD3;
   float3 N               : TEXCOORD4;
   float3 normal          : NORMAL;
   float4 position        : POSITION;
};


struct ConnectData
{
   float4 hpos            : POSITION;
   float3 cubeNormal      : TEXCOORD0;
   float3 cubeEyePos      : TEXCOORD1;
   float3 pos             : TEXCOORD2;
};

/*
struct ConnectData
{
   float4 hpos            : POSITION;
   float3 reflectVec      : TEXCOORD0;
};
*/

//-----------------------------------------------------------------------------
// Main                                                                        
//-----------------------------------------------------------------------------
ConnectData main( VertData IN,
                  uniform float4x4 modelview       : register(C0),
                  uniform float3x3 cubeTrans       : register(C16),
                  uniform float3   cubeEyePos      : register(C19),
                  uniform float3   eyePos          : register(C20)
)
{
   ConnectData OUT;


   OUT.hpos = mul(modelview, IN.position);
   float3 normal = normalize( IN.position );
   OUT.cubeNormal = normalize( mul(cubeTrans, normal).xyz );
   OUT.cubeEyePos = cubeEyePos / 100.0;
   OUT.pos = mul(cubeTrans, IN.position / 100.0).xyz;


/*   
   OUT.hpos = mul(modelview, IN.position);
   float3 cubeNormal = normalize( mul(cubeTrans, IN.normal).xyz );
   float3 cubeVertPos = mul(cubeTrans, IN.position).xyz;
   float3 eyeToVert = cubeVertPos - cubeEyePos;
   OUT.reflectVec = reflect(eyeToVert, cubeNormal);
*/

   return OUT;
}
