//*****************************************************************************
// TSE -- HLSL procedural shader                                               
//*****************************************************************************
//-----------------------------------------------------------------------------
// Structures                                                                  
//-----------------------------------------------------------------------------
struct ConnectData
{
   float2 texCoord        : TEXCOORD0;
   float2 lmCoord         : TEXCOORD1;
   float4 shading         : COLOR;
   float3 normal          : TEXCOORD2;
   float3 pixPos          : TEXCOORD3;
   float3 eyePos          : TEXCOORD4;
   float4 lightVec        : TEXCOORD5;
   float2 fogCoord        : TEXCOORD6;
};


struct Fragout
{
   float4 col : COLOR0;
};


//-----------------------------------------------------------------------------
// Main                                                                        
//-----------------------------------------------------------------------------
Fragout main( ConnectData IN,
              uniform sampler2D diffuseMap      : register(S0),
              uniform sampler2D lightMap        : register(S1),
              uniform float4    ambient         : register(C2),
              uniform float4    specularColor   : register(C0),
              uniform float     specularPower   : register(C1),
              uniform sampler2D fogMap          : register(S2)
)
{
   Fragout OUT;

   float4 diffuseColor = tex2D(diffuseMap, IN.texCoord);
   OUT.col = diffuseColor;
   OUT.col *= tex2D(lightMap, IN.lmCoord) * IN.shading + ambient;

   float3 eyeVec = normalize(IN.eyePos - IN.pixPos);
   float3 halfAng = normalize(eyeVec + IN.lightVec.xyz);
   float specular = saturate( dot(IN.normal.xyz, halfAng) ) * IN.lightVec.w;
   specular = pow(specular, specularPower);
   OUT.col += specularColor * specular * tex2D(lightMap, IN.lmCoord) * diffuseColor.a;
   float4 fogColor = tex2D(fogMap, IN.fogCoord);
   OUT.col = lerp( OUT.col, fogColor, fogColor.a );

   return OUT;
}
