unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, MPlayer, StdCtrls;

type
  TForm1 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    pnlAVI: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    OpenAVI1: TMenuItem;
    SaveBMP1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Edit1: TEdit;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    SaveDialog1: TSaveDialog;
    Label1: TLabel;
    procedure Exit1Click(Sender: TObject);
    procedure OpenAVI1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SaveBMP1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.OpenAVI1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    MediaPlayer1.FileName := OpenDialog1.Filename;
    MediaPlayer1.Open;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i : integer;
  nSlotWidth : integer;
  nCurrCol : integer;
  nSourceX : integer;
  aviHDC : HDC;
begin
  // Get slot width, calculate starting position
  nSlotWidth := StrToInt(Edit1.Text);
  nSourceX := (pnlAVI.Width div 2) - (nSlotWidth div 2);
  // Set up the media player, we want to skip a frame at a time
  // and we want to wait for the step to finish before returning control
  MediaPlayer1.Frames := 1;
  MediaPlayer1.Wait := True;
  // Get the device context of the panel
  aviHDC := GetDC(pnlAVI.Handle);
  // Make sure the destination image is long enough
  Image1.Width := MediaPlayer1.Length * nSlotWidth;
  nCurrCol := 0;
  for i := 0 to MediaPlayer1.Length - 1 do
  begin
    MediaPlayer1.Step;
    BitBlt(Image1.Canvas.Handle, nCurrCol, 0, nSlotWidth, Image1.Height,
      aviHDC, nSourceX, 0, SRCCOPY);
    nCurrCol := nCurrCol + nSlotWidth;    
  end;
end;

procedure TForm1.SaveBMP1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    Image1.Picture.SaveToFile(SaveDialog1.Filename);
  end;
end;

end.
